package net.pushnara.fcm;

import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;

import net.pushnara.PushNara;

/**
 * Created by Songs on 2017. 1. 20..
 */
public class PushNaraFirebaseInstanceIDService extends FirebaseInstanceIdService {
    private static final String TAG = "PushNara";

    @Override
    public void onTokenRefresh() {
        //등록된 토큰을 가져옵니다
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();
        Log.d(TAG, "Refreshed token: " + refreshedToken);
        sendRegistrationToServer(refreshedToken);
    }

    private void sendRegistrationToServer(String token) {
        //푸시나라에 토큰을 업데이트 해줍니다
        PushNara.UpdateToken(token);
    }
}
