package net.pushnara.fcm;

import android.app.AlertDialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.NotificationCompat;
import android.util.Log;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;

import net.pushnara.PushNara;
import net.pushnara.http.HttpRequestDownloadEvent;
import net.pushnara.sample.MainActivity;
import net.pushnara.sample.R;

import org.json.JSONObject;
import java.io.InputStream;
import java.util.Map;


/**
 * Created by Songs on 2017. 1. 20..
 */
public class PushNaraFirebaseMessagingService extends FirebaseMessagingService {


    private static final String TAG = "PushNara";

    Handler mEventHandler = new Handler() {
        public void handleMessage(Message msg) {
            Bundle data = msg.getData();
            String sTitle = data.getString("title");
            String sMessage = data.getString("msg");
            String sLink = data.getString("link");
            if(sLink != null)
            {
                sMessage = sMessage + "\n해당 화면으로 이동 하시겠습니까?";
                onRecevedLinkAlert(sTitle,sMessage,sLink);
            }
            else
                onRecevedAlert(sTitle,sMessage);
        }
    };

    public void onRecevedAlert(String sTitle,String sMessage)
    {
        try {
            AlertDialog.Builder alert_confirm = new AlertDialog.Builder(MainActivity.gMainActivity);
            alert_confirm.setMessage(sMessage).setTitle(sTitle).setCancelable(false).setPositiveButton("확인",
                    new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                        }
                    });
            AlertDialog alert = alert_confirm.create();
            alert.show();
        }catch(Exception e)
        {
            Log.e(TAG,"onRcv " + e.getLocalizedMessage());
        }

    }


    public void onRecevedLinkAlert(String sTitle,String sMessage,final  String sLink)
    {
        try {
            AlertDialog.Builder alert_confirm = new AlertDialog.Builder(MainActivity.gMainActivity);
            alert_confirm.setMessage(sMessage).setTitle(sTitle).setCancelable(false).setPositiveButton("확인",
                    new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            //하이브리드 웹일 경우 바로 웹뷰를 가져와서 이동을 해준다
                            //MainActivity.gMainActivity.GetWebView().loadUrl(sLink);
                            dialog.dismiss();
                        }
                    }).setNegativeButton("취소",
                    new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    });

            AlertDialog alert = alert_confirm.create();
            alert.show();
        }catch(Exception e)
        {
            Log.e(TAG,"onRcv " + e.getLocalizedMessage());
        }
    }

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {

        //Displaying data in log
        //It is optional
        Log.d(TAG, "From: " + remoteMessage.getFrom());


        Message msg = mEventHandler.obtainMessage();
        Map<String,String> data = null;
        if (remoteMessage.getData().size() > 0) {
            Log.e(TAG, "Data Payload: " + remoteMessage.getData().toString());
            try {
                data = remoteMessage.getData();
                if (MainActivity.gbActive == false) {
                    //노티바에 넣어준다
                    sendNotification(data.get("title"), data.get("msg"), data);
                } else {
                    //Alert을 여기서 보여주면 에러가 난다 그래서 핸들러를 통해서 alert보여준다
                    Message message = mEventHandler.obtainMessage();
                    Bundle b = new Bundle();
                    b.putString("title",data.get("title"));
                    b.putString("msg",data.get("msg"));
                    b.putString("link",data != null ? data.get("link") : null);
                    message.setData(b);
                    mEventHandler.sendMessage(message);
                }
            } catch (Exception e) {
                Log.e(TAG, "Exception: " + e.getMessage());
            }
        }

        //서버에서 알람센터로 notification/title , body로 데이터를 넣어줄때 사용한다
//        if (MainActivity.gbActive == false) {
//            //노티바에 넣어준다
//            sendNotification(remoteMessage.getNotification().getTitle(), remoteMessage.getNotification().getBody(), data);
//        } else {
//            //Alert을 여기서 보여주면 에러가 난다 그래서 핸들러를 통해서 alert보여준다
//            Message message = mEventHandler.obtainMessage();
//            Bundle b = new Bundle();
//            b.putString("title",remoteMessage.getNotification().getTitle());
//            b.putString("body",remoteMessage.getNotification().getBody());
//            message.setData(b);
//            mEventHandler.sendMessage(message);
//        }

    }

    //푸시 메세지가 왔으면 푸시를 알람바에 넣어준다
    private void sendNotification(String messageTitle, String messageBody, Map<String,String> data) {
        final Context context = getBaseContext();
        try {
            Intent intent = new Intent(this, MainActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
            final PendingIntent pi = PendingIntent.getActivity(this, 0, intent, PendingIntent.FLAG_UPDATE_CURRENT);
            final String push_message = messageTitle;//data.getString("msg");
            final NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context);

            mBuilder.setSmallIcon(R.drawable.ic_launcher);
            mBuilder.setContentTitle(context.getResources().getString(R.string.app_name));
            mBuilder.setContentText(push_message);
            mBuilder.setVibrate(new long[]{1000, 1000, 1000, 1000, 1000});
            mBuilder.setLights(Color.RED, 3000, 3000);
            Uri notificationsound = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
            mBuilder.setSound(notificationsound);

            //String sLink = data != null ? data.get("link") : null;
            String sImageFile = data != null ? data.get("image") : null;
            if (sImageFile != null) {
                PushNara.DownLoadImage(sImageFile, new HttpRequestDownloadEvent() {
                    @Override
                    public void OnDownloaded(int nResult, String sFileName, InputStream input) {
                        if (nResult == 0 && input != null) //Success
                        {
                            try {
                                //BitmapFactory.Options options = new BitmapFactory.Options();
                                //options.inPreferredConfig = Bitmap.Config.ARGB_8888;
                                Bitmap bitmap = BitmapFactory.decodeStream(input);
                                NotificationCompat.BigPictureStyle notification = new NotificationCompat.BigPictureStyle();
                                notification.setBigContentTitle(context.getResources().getString(R.string.app_name));
                                notification.bigPicture(bitmap);
                                notification.setSummaryText(push_message);
                                mBuilder.setStyle(notification);
                                showNoti(context, mBuilder, pi);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            NotificationCompat.BigTextStyle notification = new NotificationCompat.BigTextStyle();
                            notification.setBigContentTitle(context.getResources().getString(R.string.app_name));
                            notification.bigText(push_message);
                            mBuilder.setStyle(notification);
                            showNoti(context, mBuilder, pi);
                        }
                    }
                });
            } else {
                NotificationCompat.BigTextStyle notification = new NotificationCompat.BigTextStyle();
                notification.setBigContentTitle(context.getResources().getString(R.string.app_name));
                notification.bigText(push_message);
                mBuilder.setStyle(notification);
                showNoti(context, mBuilder, pi);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void showNoti(Context context, NotificationCompat.Builder mBuilder, PendingIntent pi) {
        mBuilder.setContentIntent(pi);
        mBuilder.setPriority(NotificationCompat.PRIORITY_MAX);

        Notification noti = mBuilder.build();
        noti.flags |= Notification.FLAG_AUTO_CANCEL;

        // Send the notification.
        ((NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE)).notify(0, noti);
    }

}
