package net.pushnara.sample;

import java.util.Map;

import net.pushnara.PushNara;
import net.pushnara.PushNaraEvent;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.ToggleButton;

public class MainActivity extends Activity{

	public static boolean gbActive = false;
	public static MainActivity gMainActivity;

	EditText mtxtUpdateUserID;
	EditText mtxtUpdateGroupID;
	TextView mtxtSettings;
	ToggleButton mbtnPrivateEnable;
	ToggleButton mbtnPublicEnable;
	
	@Override
	public void onCreate(Bundle savedInstanceSate)
	{
		super.onCreate(savedInstanceSate);
		gMainActivity = this;
		setContentView(R.layout.activity_main);
		//푸시 초기화를 합니다.
        PushNara.InitPushNara(this, "1484636886297", event);
        //푸시 설정을 가져와서 초기화를 해준다.
    	PushNara.GetPushSettings();

    	mtxtSettings = (TextView)this.findViewById(R.id.txtGetSettings);
    	mtxtUpdateUserID = (EditText)this.findViewById(R.id.txtUpdateUserID);
    	Button btnUpdateUserID = (Button)this.findViewById(R.id.btnUpdateUserID);
    	btnUpdateUserID.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {	
				if(mtxtUpdateUserID.getText().toString().length() == 0)
				{
					ShowAlert("사용자 ID를 입력하세요");
					return ;
				}
				//사용자 정보를 업데이트 해줍니다.
				PushNara.UpdateUserID(mtxtUpdateUserID.getText().toString());
			}
		});
    	
    	
    	
    	mtxtUpdateGroupID = (EditText)this.findViewById(R.id.txtUpdateGroupID);
    	Button btnUpdateGroupID = (Button)this.findViewById(R.id.btnUpdateGroupID);
    	btnUpdateGroupID.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {	
				if(mtxtUpdateGroupID.getText().toString().length() == 0)
				{
					ShowAlert("Group ID를 입력하세요");
					return ;
				}
				
				//그룹정보를 업데이트 해줍니다.
				PushNara.UpdateGroupID(mtxtUpdateGroupID.getText().toString());
			}
		});
    	
    	
    	mbtnPrivateEnable = (ToggleButton)this.findViewById(R.id.btnPrivateEnable);
    	mbtnPrivateEnable.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {	
				//개인 알람 설정 정보를 올려준다.
				PushNara.EnablePrivatePush(mbtnPrivateEnable.isChecked());
			}
		});
    	
    	mbtnPublicEnable = (ToggleButton)this.findViewById(R.id.btnPublicEnable);
    	mbtnPublicEnable.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {	
				//개인 알람 설정 정보를 올려준다.
				PushNara.EnablePublicPush(mbtnPublicEnable.isChecked());
			}
		});
    	
    	
    	Button btnGetSettings = (Button)this.findViewById(R.id.btnGetSettings);
    	btnGetSettings.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				//그룹정보를 업데이트 해줍니다.
				PushNara.GetPushSettings();
			}
		});


		//푸시 메세지의 알람바를 클릭하면 실행시 로직을 처리해준다 link가 있을 경우 바로 페이지로 이동을 해준다
		Intent intent = this.getIntent();
		if(intent != null)
		{
			Bundle bundle = intent.getExtras();
			if(bundle != null)
			{
				//푸시에 이동 링크가 내려온다면 바로 사이트로 이동하게 하였습니다
				msLink = bundle.getString("link");
				msPushMsg = bundle.getString("msg");
				msPushTitle = bundle.getString("title");
				if(msLink != null && msLink.length() != 0)
				{
                    mRunnable = new Runnable() {
                        @Override
                        public void run() {
                            //웹뷰이면 바로 URL로 이동을 해준다
							//mWebView.loadUrl(msLink);
							msLink = null;
                        }
                    };
                    mHandler = new Handler();
                    mHandler.postDelayed(mRunnable, 1000);
				}
			}
		}
	}

	//푸시메세지를 클릭하여 앱이 실행될때 사용을 한다
	String msLink;
	String msPushMsg;
	String msPushTitle;
	Handler mHandler;
	Runnable mRunnable;
	
	PushNaraEvent event = new PushNaraEvent()
	{

		@Override
		public void OnUpdateUserID(int nResult, String sData) {
			mtxtSettings.setText(sData);
			
			if(nResult == 0)
			{
				
			}
			else
			{
				Log.e("PushNara", "UpdateUserID " + sData);
			}
		}

		@Override
		public void OnUpdateGroupID(int nResult, String sData) {
			mtxtSettings.setText(sData);
			
			if(nResult == 0)
			{
				
			}
			else
			{
				Log.e("PushNara", "UpdateGroupID " + sData);
			}
		}

		@Override
		public void OnUpdateToken(int nResult, String sData) {
			mtxtSettings.setText(sData);
			
			if(nResult == 0)
			{
				
			}
			else
			{
				Log.e("PushNara", "UpdateToken " + sData);
			}
		}

		@Override
		public void OnGetPushSettings(int nResult, String sData) {
			mtxtSettings.setText(sData);
			
			if(nResult == 0)
			{
				GetSetting(sData);
			}
			else
			{
				Log.e("PushNara", "GetPushSettings " + sData);
			}
		}

		@Override
		public void OnEnablePublicPush(int nResult, String sData) {
			
			if(nResult == 0)
			{
				
			}
			else
			{
				Log.e("PushNara", "EnablePublicPush " + sData);
			}
			
		}

		@Override
		public void OnEnablePrivatePush(int nResult, String sData) {
			if(nResult == 0)
			{
				
			}
			else
			{
				Log.e("PushNara", "EnablePrivatePush " + sData);
			}
			
		}
	};
	
	void GetSetting(String sData)
	{
		try
		{
			Map<String,String> dic = PushNara.GetSettings(sData);
			
			this.mtxtUpdateUserID.setText(dic.get("userid"));
			this.mtxtUpdateGroupID.setText(dic.get("groupid"));
			boolean bEnable = Integer.parseInt(dic.get("public")) != 0 ? true : false;
			mbtnPublicEnable.setChecked(bEnable);
			bEnable = Integer.parseInt(dic.get("private")) != 0 ? true : false;
			mbtnPrivateEnable.setChecked(bEnable);
		}
		catch(Exception e)
		{
			Log.e("PushNara","GetSetting " + e.getLocalizedMessage());
		}
	}
	
	void ShowAlert(String sMessage)
	{
		AlertDialog.Builder alert = new AlertDialog.Builder(MainActivity.this);
		alert.setPositiveButton("확인", new DialogInterface.OnClickListener() {
		    @Override
		    public void onClick(DialogInterface dialog, int which) {
		    dialog.dismiss();     //닫기
		    }
		});
		alert.setMessage(sMessage);
		alert.show();
	}
	
	
	@Override
	public void onResume() {
    	super.onResume();
	}

	@Override
	public void onStart() {
		super.onStart();
		gbActive = true;
	}

	@Override
	public void onStop() {
		super.onStop();
		gbActive = false;
	}
}
