//
//  HttpAsyncMan.h
//  MiapsFramework
//
//  Created by Hohak Song on 2016. 11. 15..
//  Copyright © 2016년 thinkm. All rights reserved.
//

#import <Foundation/Foundation.h>
typedef void (^PushResult)(NSData *data, NSError *error);

@interface NSURLConnectionEx : NSURLConnection
{
    NSString* msID;
}
@property (nonatomic,retain) NSString* msID;
@end

@interface AsyncData : NSObject
{
    NSMutableData*      mRcvData;
    NSURLConnectionEx*  mConn;
    int                 mnStatusCode;
    PushResult          mTargetFunc;
}
@property (nonatomic,strong) PushResult      mTargetFunc;
@property (nonatomic,strong) NSMutableData*      mRcvData;
@property (nonatomic,strong) NSURLConnectionEx*    mConn;
@property (nonatomic,assign) int                 mnStatusCode;
@end


@protocol HttpAsyncDelegate <NSObject>
- (void)OnHttpResult:(NSString*)sID ResultDoc:(AsyncData *)result;
@end



@class HttpRequestMoreData;
@interface HttpPushAsyncMan : NSObject
{
    NSMutableDictionary* mHttpMap;
}
@property (nonatomic, retain) id<HttpAsyncDelegate> delegate;

// 일반 HTTP 요청
-(void) RequestHttp:(NSString *)sID URL:(NSString*)sURL Post:(NSString*)sPost TargetFunc:(PushResult)TargetFunc;
-(void) CancelHttp:(NSString*)sID;
@end
