/*
 * Decompiled with CFR 0.152.
 */
package net.pushnara;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import net.pushnara.PushNaraEvent;
import net.pushnara.http.HttpRequestDownloadEvent;
import net.pushnara.http.HttpRequestMan;
import net.pushnara.http.IHttpRequestMan;

public class PushNara
implements IHttpRequestMan {
    static String sVersion = "1.00";
    public static String ID_UpdateUserID = "UpdateUserID";
    public static String ID_UpdateGroupID = "UpdateGroupID";
    public static String ID_UpdateToken = "UpdateToken";
    public static String ID_GetPushSettings = "GetPushSettings";
    public static String ID_EnablePublicPush = "EnablePublicPush";
    public static String ID_EnablePrivatePush = "EnablePrivatePush";
    public static String ID_DonloadImage = "DonloadImage";
    HttpRequestMan mHttpConnection;
    String mUserID;
    String mGroupID;
    String mPushNaraProjectID;
    String mPushToken;
    Activity mActivity;
    String mPuserServerURL = "http://www.pushnara.co.kr/pushsvc";
    static PushNara gPushNara = null;
    PushNaraEvent mEvent;

    public static void InitPushNara(Activity activity, String sPushNaraProjectID, PushNaraEvent Event) {
        gPushNara = new PushNara(sPushNaraProjectID, Event);
        PushNara.gPushNara.mActivity = activity;
    }

    public static void UpdateUserID(String sUserID) {
        gPushNara.UpdateUserID_(sUserID);
    }

    public static void UpdateGroupID(String sGroupID) {
        gPushNara.UpdateGroupID_(sGroupID);
    }

    public static void UpdateToken(String PushToken) {
        gPushNara.UpdateToken_(PushToken);
    }

    public static void GetPushSettings() {
        gPushNara.GetPushSettings_();
    }

    public static void EnablePublicPush(boolean bEnable) {
        gPushNara.EnablePublicPush_(bEnable);
    }

    public static void EnablePrivatePush(boolean bEnable) {
        gPushNara.EnablePrivatePush_(bEnable);
    }

    public static void DownLoadImage(String sFileName, HttpRequestDownloadEvent event) {
        gPushNara.DownLoadImage_(sFileName, event);
    }

    public static Map<String, String> GetSettings(String sData) {
        String[] sArr;
        HashMap<String, String> dic = new HashMap<String, String>();
        sData = sData.substring(2);
        String[] stringArray = sArr = sData.split("&");
        int n = sArr.length;
        int n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            String[] arr = ss.split("=");
            if (arr.length == 2) {
                dic.put(arr[0], URLDecoder.decode(arr[1]));
            } else {
                dic.put(arr[0], "");
            }
            ++n2;
        }
        return dic;
    }

    PushNara(String sProjectID, PushNaraEvent Event) {
        this.mPushNaraProjectID = sProjectID;
        this.mHttpConnection = new HttpRequestMan();
        this.mHttpConnection.setInterface(this);
        this.mEvent = Event;
    }

    void UpdateUserID_(String sUserID) {
        this.mUserID = sUserID;
        int nType = 33;
        String sPostData = String.format("cmd=updateuserid&ver=%s&appid=%s&bundleid=%s&deviceid=%s&appver=%s&type=%d&userid=%s", sVersion, this.mPushNaraProjectID, this.GetBundleID(), this.GetDeviceID(), this.GetAppVersion(), nType, this.mUserID);
        this.mHttpConnection.RequestHttp(ID_UpdateUserID, this.mPuserServerURL, sPostData, "", "", 30.0f);
    }

    void UpdateGroupID_(String sGroupID) {
        this.mGroupID = sGroupID;
        int nType = 33;
        String sPostData = String.format("cmd=updategroupid&ver=%s&appid=%s&bundleid=%s&deviceid=%s&appver=%s&type=%d&groupid=%s", sVersion, this.mPushNaraProjectID, this.GetBundleID(), this.GetDeviceID(), this.GetAppVersion(), nType, this.mGroupID);
        this.mHttpConnection.RequestHttp(ID_UpdateGroupID, this.mPuserServerURL, sPostData, "", "", 30.0f);
    }

    void UpdateToken_(String PushToken) {
        this.mPushToken = PushToken;
        int nType = 33;
        String sPostData = String.format("cmd=updatetoken&ver=%s&appid=%s&bundleid=%s&deviceid=%s&appver=%s&type=%d&token=%s", sVersion, this.mPushNaraProjectID, this.GetBundleID(), this.GetDeviceID(), this.GetAppVersion(), nType, this.mPushToken);
        this.mHttpConnection.RequestHttp(ID_UpdateToken, this.mPuserServerURL, sPostData, "", "", 30.0f);
    }

    void GetPushSettings_() {
        String sPostData = String.format("cmd=getpushsettings&deviceid=%s&appid=%s", this.GetDeviceID(), this.mPushNaraProjectID);
        this.mHttpConnection.RequestHttp(ID_GetPushSettings, this.mPuserServerURL, sPostData, "", "", 30.0f);
    }

    void EnablePublicPush_(boolean bEnable) {
        int nType = 33;
        String sPostData = String.format("cmd=enablepublicpush&ver=%s&appid=%s&bundleid=%s&deviceid=%s&appver=%s&type=%d&enable=%d", sVersion, this.mPushNaraProjectID, this.GetBundleID(), this.GetDeviceID(), this.GetAppVersion(), nType, bEnable ? 1 : 0);
        this.mHttpConnection.RequestHttp(ID_EnablePublicPush, this.mPuserServerURL, sPostData, "", "", 30.0f);
    }

    void EnablePrivatePush_(boolean bEnable) {
        int nType = 33;
        String sPostData = String.format("cmd=enableprivatepush&ver=%s&appid=%s&bundleid=%s&deviceid=%s&appver=%s&type=%d&enable=%d", sVersion, this.mPushNaraProjectID, this.GetBundleID(), this.GetDeviceID(), this.GetAppVersion(), nType, bEnable ? 1 : 0);
        this.mHttpConnection.RequestHttp(ID_EnablePrivatePush, this.mPuserServerURL, sPostData, "", "", 30.0f);
    }

    void DownLoadImage_(String sFileName, HttpRequestDownloadEvent event) {
        int nIndex = this.mPuserServerURL.lastIndexOf(47);
        String sURLRoot = this.mPuserServerURL.substring(0, nIndex);
        String sURL = String.format("%s/downloadpushimg.jsp?filename=%s", sURLRoot, sFileName);
        this.mHttpConnection.RequestDownloadFile(ID_DonloadImage, sURL, event);
    }

    String GetBundleID() {
        String ID = this.mActivity.getPackageName();
        if (ID == null || ID != null && ID.length() == 0) {
            ID = "packageid is NULL";
        }
        return ID;
    }

    String GetDeviceID() {
        String id = null;
        try {
            id = Settings.Secure.getString((ContentResolver)this.mActivity.getContentResolver(), (String)"android_id");
        }
        catch (Exception ex) {
            Log.e((String)"SongsJava", (String)("GetDeviceID " + ex.getLocalizedMessage()));
        }
        if (id == null || id.length() == 0) {
            try {
                Build bd = new Build();
                id = Build.SERIAL;
            }
            catch (Exception ex) {
                Log.e((String)"SongsJava", (String)("GetDeviceID1 " + ex.getLocalizedMessage()));
            }
        }
        if (id == null || id.length() == 0) {
            try {
                WifiManager manager = (WifiManager)this.mActivity.getSystemService("wifi");
                WifiInfo info = manager.getConnectionInfo();
                id = info.getMacAddress();
            }
            catch (Exception ex) {
                Log.e((String)"SongsJava", (String)("GetDeviceID2 " + ex.getLocalizedMessage()));
            }
        }
        if (id == null || id.length() == 0) {
            id = "Not found serial number";
        }
        return String.valueOf(this.GetBundleID()) + "." + id;
    }

    String GetAppVersion() {
        String sVersion = "0.00";
        try {
            sVersion = this.mActivity.getPackageManager().getPackageInfo((String)this.GetBundleID(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return sVersion;
    }

    @Override
    public void OnHttpResponse(String sTransID, int nResult, String sRcvData, String sURL) {
        if (sTransID.compareTo(ID_UpdateUserID) == 0) {
            this.mEvent.OnUpdateUserID(nResult, sRcvData);
        } else if (sTransID.compareTo(ID_UpdateGroupID) == 0) {
            this.mEvent.OnUpdateGroupID(nResult, sRcvData);
        } else if (sTransID.compareTo(ID_UpdateToken) == 0) {
            this.mEvent.OnUpdateToken(nResult, sRcvData);
        } else if (sTransID.compareTo(ID_GetPushSettings) == 0) {
            this.mEvent.OnGetPushSettings(nResult, sRcvData);
        } else if (sTransID.compareTo(ID_EnablePublicPush) == 0) {
            this.mEvent.OnEnablePublicPush(nResult, sRcvData);
        } else if (sTransID.compareTo(ID_EnablePrivatePush) == 0) {
            this.mEvent.OnEnablePrivatePush(nResult, sRcvData);
        }
    }
}

