/*
 * Decompiled with CFR 0.152.
 */
package net.pushnara.http;

import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.pushnara.http.ASendDataToServer;
import net.pushnara.http.CExceptionNetwork;
import net.pushnara.http.CThreadEvent;
import net.pushnara.http.IProgress;

public class CHttpRequest
extends ASendDataToServer {
    int m_nThreadError = 0;
    String m_sThreadError = "";
    InputStream m_outThreadStream = null;
    CThreadEvent m_hThreaWaitEvent = null;
    Thread m_hThreaWaitThread = null;
    byte[] m_btInXmlSend = null;
    String m_sFileName = null;
    static String gCookie = null;
    long m_lHandle;

    public CHttpRequest(String surl, IProgress proc, int nRequestTimeOut) {
        super(surl, proc, nRequestTimeOut);
    }

    public CHttpRequest(String surl, IProgress proc) {
        super(surl, proc, DEFAULT_TIMEOUT);
    }

    public CHttpRequest(String surl, String sDir, IProgress proc, int nRequestTimeOut) {
        super(surl, proc, nRequestTimeOut);
    }

    public CHttpRequest(String surl, String sDir, IProgress proc) {
        super(surl, proc, DEFAULT_TIMEOUT);
    }

    @Override
    protected void ConnectNet() {
        if (this.m_syncProgress != null) {
            this.m_syncProgress.ConnectNet();
        }
    }

    @Override
    protected void ConnectHttp() throws IOException {
        URL url = null;
        this.DisconnectHttp();
        if (this.m_syncProgress != null) {
            this.m_syncProgress.ConnectHttp();
        }
        if ((url = new URL(this.m_sURL)).getProtocol().toLowerCase().equals("https")) {
            System.setProperty("http.keepAlive", "false");
            FakeX509TrustManager.allowAllSSL();
            this.m_Conn = (HttpsURLConnection)url.openConnection();
        } else {
            this.m_Conn = (HttpURLConnection)url.openConnection();
        }
    }

    @Override
    public void DisconnectHttp() {
        if (this.m_hThreaWaitEvent != null) {
            this.m_hThreaWaitEvent.signalAll();
            this.m_hThreaWaitEvent = null;
        }
        if (this.m_syncProgress != null) {
            this.m_syncProgress.DisconnectHttp();
        }
        if (this.m_Conn != null) {
            this.m_Conn.disconnect();
            this.m_Conn = null;
        }
    }

    public static boolean writeContent(InputStream inputStream, String sPath) {
        FileOutputStream outStream = null;
        try {
            try {
                outStream = new FileOutputStream(sPath);
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = inputStream.read(buf)) > 0) {
                    ((OutputStream)outStream).write(buf, 0, len);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (outStream != null) {
                    try {
                        ((OutputStream)outStream).close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    outStream = null;
                }
                return false;
            }
            catch (IOException e) {
                block19: {
                    e.printStackTrace();
                    if (outStream == null) break block19;
                    try {
                        ((OutputStream)outStream).close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    outStream = null;
                }
                return false;
            }
        }
        finally {
            if (outStream != null) {
                try {
                    ((OutputStream)outStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                outStream = null;
            }
        }
        return true;
    }

    public static byte[] readContent(InputStream in, int bufferSize) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[bufferSize];
        int c = 0;
        int b = 0;
        while (c < buf.length && (b = in.read(buf, c, buf.length - c)) >= 0) {
            if ((c += b) != bufferSize) continue;
            bout.write(buf);
            buf = new byte[bufferSize];
            c = 0;
        }
        if (c != 0) {
            bout.write(buf, 0, c);
        }
        return bout.toByteArray();
    }

    public String getFileName() {
        return this.m_sFileName;
    }

    /*
     * Unable to fully structure code
     */
    public void SendDataThread(byte[] btXmlSend, long lHandle) {
        outStream = null;
        try {
            if (this.m_syncProgress != null) {
                this.m_syncProgress.SendTotalSize(btXmlSend.length);
            }
            if (btXmlSend == null || btXmlSend.length <= 0) ** GOTO lbl16
            outStream = this.m_Conn.getOutputStream();
            if (outStream == null) {
                this.m_nThreadError = -1001;
                this.m_sThreadError = "outStream \ubcf4\ub0bc\uc218\uac00 \uc5c6\uc2b5\ub2c8\ub2e4";
                return;
            }
            try {
                outStream.write(btXmlSend);
                outStream.flush();
                outStream.close();
                outStream = null;
lbl16:
                // 2 sources

                nResponse = this.m_Conn.getResponseCode();
                switch (nResponse) {
                    case 200: {
                        break;
                    }
                    default: {
                        throw new CExceptionNetwork(-1002L, this.m_Conn.getResponseMessage());
                    }
                }
                this.m_nContentsSize = 0;
                sBufferSize = this.m_Conn.getHeaderField("Content-Length");
                if (sBufferSize != null) {
                    this.m_nContentsSize = Integer.parseInt(sBufferSize);
                }
                if (this.m_syncProgress != null) {
                    this.m_syncProgress.RcvTotalSize(this.m_nContentsSize);
                }
                if ((sContentType = this.m_Conn.getHeaderField("Content-Type")) != null) {
                    nPos = sContentType.indexOf("charset=");
                    if (nPos != -1) {
                        this.msCharset = sContentType.substring(nPos + 8);
                    }
                } else {
                    sContentType = "not";
                }
                if ((sCookie = this.m_Conn.getHeaderField("Set-Cookie")) != null && (nPos = sCookie.indexOf(";")) != -1) {
                    CHttpRequest.gCookie = sCookie.substring(0, nPos);
                }
                if ((sContentDispos = this.m_Conn.getHeaderField("Content-Disposition")) != null && sContentDispos.contains("attatchment;")) {
                    nIndex = sContentDispos.lastIndexOf(61);
                    if (nIndex != -1) {
                        this.m_sFileName = sContentDispos.substring(nIndex + 1);
                        this.m_sFileName = this.m_sFileName.trim();
                    } else {
                        this.m_sFileName = sContentDispos.replaceFirst("(?i)^.*filename = \"([^\"]+)\".*$", "$1");
                    }
                }
                this.m_outThreadStream = this.m_Conn.getInputStream();
            }
            catch (MalformedURLException e) {
                this.m_nThreadError = -1003;
                this.m_sThreadError = e.getMessage();
            }
            catch (IOException e) {
                this.m_nThreadError = -1004;
                this.m_sThreadError = e.getMessage();
            }
            catch (Exception e) {
                this.m_nThreadError = -1005;
                this.m_sThreadError = e.getMessage();
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.flush();
                    outStream.close();
                }
                catch (IOException e) {
                    this.m_nThreadError = -1006;
                    this.m_sThreadError = "outStream Close Error " + e.getMessage();
                }
                outStream = null;
            }
            if (this.m_hThreaWaitEvent != null) {
                this.m_hThreaWaitEvent.signal();
            }
        }
    }

    @Override
    public InputStream SendData(byte[] btXmlSend, String sHttpHeader, long lHandle) throws CExceptionNetwork {
        InputStream inStream = null;
        try {
            try {
                this.m_nContentsSize = 0;
                this.m_nThreadError = 0;
                this.m_sThreadError = "";
                this.m_outThreadStream = null;
                this.m_hThreaWaitEvent = null;
                this.m_hThreaWaitThread = null;
                this.m_btInXmlSend = null;
                this.m_lHandle = lHandle;
                this.ConnectNet();
                this.ConnectHttp();
                this.m_btInXmlSend = btXmlSend;
                if (btXmlSend != null && btXmlSend.length > 0) {
                    this.m_Conn.setRequestMethod("POST");
                } else {
                    this.m_Conn.setRequestMethod("GET");
                }
                this.m_Conn.setDoOutput(true);
                this.m_Conn.setDoInput(true);
                this.m_Conn.setUseCaches(false);
                this.m_Conn.setDefaultUseCaches(false);
                this.msCharset = "";
                if (btXmlSend != null && btXmlSend.length > 0) {
                    this.m_Conn.setRequestProperty("Content-Length", Integer.toString(this.m_btInXmlSend.length));
                }
                if (gCookie != null) {
                    this.m_Conn.setRequestProperty("Cookie", gCookie);
                }
                this.m_Conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                if (sHttpHeader != null && sHttpHeader.length() > 0) {
                    String[] arrHeader = sHttpHeader.split("\\^");
                    int i = 0;
                    while (i < arrHeader.length) {
                        this.m_Conn.setRequestProperty(arrHeader[i++], arrHeader[i++]);
                    }
                }
                this.m_Conn.setConnectTimeout(this.m_nConnectionTimeOut);
                this.m_Conn.setReadTimeout(this.m_nRequestTimeOut);
                this.m_hThreaWaitEvent = new CThreadEvent();
                this.m_hThreaWaitThread = new Thread(){

                    @Override
                    public void run() {
                        CHttpRequest.this.SendDataThread(CHttpRequest.this.m_btInXmlSend, CHttpRequest.this.m_lHandle);
                    }
                };
                this.m_hThreaWaitThread.start();
                try {
                    try {
                        this.m_hThreaWaitEvent.await(this.m_nRequestTimeOut + 30000);
                    }
                    catch (Exception ex) {
                        Log.e((String)"JavaSong", (String)ex.getMessage());
                        this.m_btInXmlSend = null;
                    }
                }
                finally {
                    this.m_btInXmlSend = null;
                }
            }
            catch (Exception e) {
                throw new CExceptionNetwork(-1008L, e.getMessage());
            }
        }
        finally {
            inStream = this.m_outThreadStream;
            this.m_hThreaWaitEvent = null;
            if (this.m_nThreadError < 0) {
                throw new CExceptionNetwork(this.m_nThreadError, this.m_sThreadError);
            }
        }
        return inStream;
    }

    @Override
    public void DisconnectNet() {
        if (this.m_syncProgress != null) {
            this.m_syncProgress.DisconnectNet();
        }
    }

    @Override
    public Object SendData(String sPostData, String sCharSet, String sHttpHeader, long lHandle) throws CExceptionNetwork {
        byte[] btData = null;
        try {
            if (sPostData != null && sPostData.length() > 0) {
                btData = sCharSet == null || sCharSet != null && sCharSet.length() == 0 ? sPostData.getBytes() : (sCharSet == "UTF-8" ? sPostData.getBytes() : sPostData.getBytes(sCharSet));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.SendData(btData, sHttpHeader, lHandle);
    }

    static class FakeX509TrustManager
    implements X509TrustManager {
        private static TrustManager[] trustManagers;
        private static final X509Certificate[] _AcceptedIssuers;

        static {
            _AcceptedIssuers = new X509Certificate[0];
        }

        FakeX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public boolean isClientTrusted(X509Certificate[] chain) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] chain) {
            return true;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return _AcceptedIssuers;
        }

        public static void allowAllSSL() {
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            SSLContext context = null;
            if (trustManagers == null) {
                trustManagers = new TrustManager[]{new FakeX509TrustManager()};
            }
            try {
                context = SSLContext.getInstance("TLS");
                context.init(null, trustManagers, new SecureRandom());
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
    }
}

