/*
 * Decompiled with CFR 0.152.
 */
package net.pushnara.http;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.InputStream;
import java.util.ArrayList;
import net.pushnara.http.CExceptionNetwork;
import net.pushnara.http.CHttpRequest;
import net.pushnara.http.HttpRequestDownloadEvent;
import net.pushnara.http.IHttpRequestMan;

public class HttpRequestMan {
    ArrayList<HttpInfo> mListRequest = new ArrayList();
    IHttpRequestMan mInterface;
    long mHandle = 0L;
    protected Handler mEventHandler = new Handler(){

        public void handleMessage(Message msg) {
            int nID = msg.getData().getInt("id");
            long lHandle = msg.getData().getLong("Handle");
            String sRcvData = msg.getData().getString("RcvData");
            String sURL = msg.getData().getString("URL");
            String sTransID = msg.getData().getString("TransID");
            if (lHandle != 0L) {
                boolean bCancel = false;
                int i = 0;
                while (i < HttpRequestMan.this.mListRequest.size()) {
                    HttpInfo info = HttpRequestMan.this.mListRequest.get(i);
                    if (info.lHandle == lHandle) {
                        HttpRequestMan.this.mListRequest.remove(i);
                        bCancel = info.bCanceled;
                    }
                    ++i;
                }
                if (!bCancel && HttpRequestMan.this.mInterface != null) {
                    HttpRequestMan.this.mInterface.OnHttpResponse(sTransID, nID, sRcvData != null ? sRcvData : "", sURL != null ? sURL : "");
                }
            } else {
                Log.i((String)"javaSongs", (String)("Http Response " + sRcvData));
            }
        }
    };

    public void setInterface(IHttpRequestMan inter) {
        this.mInterface = inter;
    }

    public void RequestDownloadFile(String sTranID, String sURL, HttpRequestDownloadEvent eventDownload) {
        this.RequestHttpCancel(sTranID);
        final HttpInfo Info = new HttpInfo();
        Info.sTransID = sTranID;
        Info.lHandle = ++this.mHandle;
        Info.bCanceled = false;
        Info.eventDownload = eventDownload;
        Info.ConnHttp = new CHttpRequest(sURL, null, 6000);
        Info.hThread = new Thread(){

            @Override
            public void run() {
                try {
                    InputStream out = (InputStream)Info.ConnHttp.SendData(null, "", "", Info.lHandle);
                    if (Info.ConnHttp.getFileName() != null) {
                        Info.eventDownload.OnDownloaded(0, Info.ConnHttp.getFileName(), out);
                    } else {
                        Info.eventDownload.OnDownloaded(-1, null, out);
                    }
                }
                catch (Exception e) {
                    Info.eventDownload.OnDownloaded(-2, null, null);
                    e.printStackTrace();
                }
            }
        };
        Info.hThread.start();
        this.mListRequest.add(Info);
    }

    public void RequestHttp(String sTranID, String sURL, final String sPost, final String sPostCharSet, final String sAddHeader, float fTimeOutSec) {
        this.RequestHttpCancel(sTranID);
        final HttpInfo Info = new HttpInfo();
        Info.sTransID = sTranID;
        Info.lHandle = ++this.mHandle;
        Info.bCanceled = false;
        Info.ConnHttp = new CHttpRequest(sURL, null, 6000);
        Info.hThread = new Thread(){

            @Override
            public void run() {
                try {
                    InputStream out = (InputStream)Info.ConnHttp.SendData(sPost, sPostCharSet, sAddHeader, Info.lHandle);
                    CHttpRequest cfr_ignored_0 = Info.ConnHttp;
                    byte[] rcvData = CHttpRequest.readContent(out, Info.ConnHttp.GetContentsSize());
                    Message msg = HttpRequestMan.this.mEventHandler.obtainMessage();
                    Bundle b = new Bundle();
                    b.putInt("id", 0);
                    b.putLong("Handle", Info.lHandle);
                    b.putString("TransID", Info.sTransID);
                    String sCharSet = Info.ConnHttp.GetCharset();
                    String sRcvData = sCharSet != null && sCharSet.length() > 0 ? new String(rcvData, sCharSet) : new String(rcvData);
                    b.putString("RcvData", sRcvData);
                    msg.setData(b);
                    HttpRequestMan.this.mEventHandler.sendMessage(msg);
                }
                catch (CExceptionNetwork e) {
                    Message msg = HttpRequestMan.this.mEventHandler.obtainMessage();
                    Bundle b = new Bundle();
                    b.putInt("id", (int)e.getCode());
                    b.putLong("Handle", Info.lHandle);
                    b.putString("TransID", Info.sTransID);
                    String sRcvData = e.getLocalizedMessage();
                    b.putString("RcvData", sRcvData != null ? sRcvData : "\uc54c\uc218 \uc5c6\ub294 \uc5d0\ub7ec");
                    msg.setData(b);
                    HttpRequestMan.this.mEventHandler.sendMessage(msg);
                    e.printStackTrace();
                }
                catch (Exception e) {
                    Message msg = HttpRequestMan.this.mEventHandler.obtainMessage();
                    Bundle b = new Bundle();
                    b.putInt("id", 1);
                    b.putLong("Handle", Info.lHandle);
                    b.putString("TransID", Info.sTransID);
                    String sRcvData = e.getLocalizedMessage();
                    b.putString("RcvData", sRcvData);
                    msg.setData(b);
                    HttpRequestMan.this.mEventHandler.sendMessage(msg);
                    e.printStackTrace();
                }
            }
        };
        Info.hThread.start();
        this.mListRequest.add(Info);
    }

    public void RequestHttpCancel(String sTranID) {
        int i = 0;
        while (i < this.mListRequest.size()) {
            HttpInfo info = this.mListRequest.get(i);
            if (info.sTransID == sTranID && !info.bCanceled) {
                info.ConnHttp.DisconnectHttp();
                info.bCanceled = true;
            }
            ++i;
        }
    }

    public class HttpInfo {
        public String sTransID;
        public long lHandle;
        CHttpRequest ConnHttp;
        Thread hThread;
        boolean bCanceled;
        HttpRequestDownloadEvent eventDownload;
    }
}

