//
//  AppDelegate.m
//  PushNaraSample
//
//  Created by Hohak Song on 2016. 12. 13..
//  Copyright © 2016년 PushNara. All rights reserved.
//

#import "AppDelegate.h"
#import "ViewController.h"

@interface AppDelegate ()

@end

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    
    //푸시를 사용을 등록해줍니다.
    [self RegisterNotifications];
    
    //푸시나라 프로젝트 아이디를 등록해줍니다.
    [PushNara InitPushNara:@"1482515817193"];
    return YES;
}


- (void)applicationWillResignActive:(UIApplication *)application {
}


- (void)applicationDidEnterBackground:(UIApplication *)application {
}


- (void)applicationWillEnterForeground:(UIApplication *)application {
    
}


- (void)applicationDidBecomeActive:(UIApplication *)application {
    
}


- (void)applicationWillTerminate:(UIApplication *)application {
}

#pragma mark APNS Push Delegate
- (void)RegisterNotifications {
    if ([[UIApplication sharedApplication] respondsToSelector:@selector(isRegisteredForRemoteNotifications)]) // iOS 8
    {
        [[UIApplication sharedApplication] registerUserNotificationSettings:
         [UIUserNotificationSettings settingsForTypes:(UIUserNotificationTypeSound | UIUserNotificationTypeAlert | UIUserNotificationTypeBadge) categories:nil]
         ];
        [[UIApplication sharedApplication] registerForRemoteNotifications];
        
    }else{
        [[UIApplication sharedApplication] registerForRemoteNotificationTypes:
         (UIRemoteNotificationTypeBadge | UIRemoteNotificationTypeAlert | UIRemoteNotificationTypeSound)];
    }
}

//푸시토큰을 받아옵니다.
- (void)application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken {
    
    //푸시토큰을 푸시나라 서버에 업데이트해 줍니다.
    [PushNara UpdateToken:deviceToken Result:^(NSData *data, NSError *error) {
        if(error == nil)
        {
            NSLog(@"푸시 토큰 업데이트에 성공 하였습니다");
        }
        else
        {
            NSLog(@"[Error]Token %@ (%ld)",error.description,error.code);
        }
    }];
}

- (void)application:(UIApplication *)application didFailToRegisterForRemoteNotificationsWithError:(NSError *)error {
}

//푸시 메세지를 받았을 받는 함수입니다.
- (void)application:(UIApplication *)application didReceiveRemoteNotification:(NSDictionary *)userInfo fetchCompletionHandler:(void (^)(UIBackgroundFetchResult result))completionHandler{
    
    if([userInfo[@"aps"][@"content-available"] intValue] == 1) {
        completionHandler(UIBackgroundFetchResultNewData);
    }
    else
    {
        ViewController* ViewCon = (ViewController*) self.window.rootViewController;
        
        NSDictionary* nsDic = (NSDictionary*)userInfo[@"aps"][@"alert"];
        
        NSString* sImage = userInfo[@"image"];
        NSString* slink = userInfo[@"link"];
        //사용중에 있으면 얼락뷰를 보여준다.
        if([[UIApplication sharedApplication] applicationState] == UIApplicationStateActive)
        {
            
            [ViewCon AlertView:(NSString*)nsDic[@"title"] Msg:(NSString*)nsDic[@"body"]]; //팝업메세지를 보여준다.
        }
        else //백그라운드로 되어 있다면
        {
            
            ViewCon.mtxtSettings.text = [NSString stringWithFormat:@"Title : %@\nContents : %@",(NSString*)nsDic[@"title"],(NSString*)nsDic[@"body"]];
            
        }
        completionHandler(UIBackgroundFetchResultNoData);
    }
}

@end
