//
//  ViewController.m
//  PushNaraSample
//
//  Created by Hohak Song on 2016. 12. 13..
//  Copyright © 2016년 PushNara. All rights reserved.
//

#import "ViewController.h"
#import "AppDelegate.h"
@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    
    [self GetSetting];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

//USER ID를 푸시 서버에 보냅니다.
- (IBAction)OnSendUserID:(id)sender {
    if(self.mtxtUserID.text.length == 0)
    {
        [self AlertView:@"알림" Msg:@"사용자 ID를 입력하세요"];
        return;
    }
    
    [PushNara UpdateUserID:self.mtxtUserID.text Result:^(NSData *data, NSError *error) {
        if(error == nil)
        {
            NSLog(@"사용자 ID 업데이트에 성공 하였습니다");
        }
        else
        {
            NSLog(@"[Error]UserID %@ (%ld)",error.description,error.code);
            self.mtxtSettings.text = error.description;
        }
    }];
    
}

//그룹아이디를 업데이트합니다.
- (IBAction)OnSendGroupID:(id)sender {
   
    if(self.mtxtGroupID.text.length == 0)
    {
        [self AlertView:@"알림" Msg:@"그룹 ID를 입력하세요"];
        return;
    }
    
    [PushNara UpdateGroupID:self.mtxtGroupID.text Result:^(NSData *data, NSError *error) {
        
        if(error == nil)
        {
            NSLog(@"그룹 ID 업데이트에 성공 하였습니다");
        }
        else
        {
            NSLog(@"[Error]GroupID %@ (%ld)",error.description,error.code);
            self.mtxtSettings.text = error.description;
        }
        
    }];
}

//쪽지 같은 특정유저에게 보내지는 알람을 Enable/Disable해줍니다.
- (IBAction)OnSendPrivateEnable:(id)sender {
    
    [PushNara EnablePrivatePush:self.mbtnPrivate.on Result:^(NSData *data, NSError *error) {
        if(error == nil)
        {
            NSLog(@"공지 알람 설정에 성공 하였습니다");
        }
        else
        {
            NSLog(@"[Error]PrivateEnable %@ (%ld)",error.description,error.code);
            self.mtxtSettings.text = error.description;
        }
    }];
}

//공지/이벤트 모든 유저에게 보내지는 알람을 Enable/Disable해줍니다.
- (IBAction)OnSendPublicEnable:(id)sender {
    [PushNara EnablePublicPush:self.mbtnPublic.on Result:^(NSData *data, NSError *error) {
        if(error == nil)
        {
            NSLog(@"개인 알람 설정에 성공 하였습니다");
        }
        else
        {
            NSLog(@"[Error]PublicEnable %@ (%ld)",error.description,error.code);
        }
    }];
}

//서버에 설정되어 있는 설정정보를 알아옵니다.
- (void) GetSetting
{
    [PushNara GetPushSettings:^(NSData *data, NSError *error) {
        if(error == nil)
        {
            NSLog(@"개인 알람 설정에 성공 하였습니다");
            
            //------------------------------------------------------------------------------------
            //Data 를 사용하기 편하게 NSDictionary로 변경하여 사용을 합니다.
            NSDictionary* dic = [PushNara GetSettings:[NSString stringWithUTF8String:[data bytes]]];
            self.mtxtUserID.text = [dic objectForKey:@"userid"];
            self.mtxtGroupID.text = [dic objectForKey:@"groupid"];
            self.mbtnPublic.on = [[dic objectForKey:@"public"] integerValue];
            self.mbtnPrivate.on = [[dic objectForKey:@"private"] integerValue];
            //------------------------------------------------------------------------------------
            
            
            self.mtxtSettings.text = [NSString stringWithUTF8String:[data bytes]];
        }
        else
        {
            NSLog(@"[Error]PublicEnable %@ (%ld)",error.description,error.code);
        }
    }];
}

- (IBAction)OnGetSettings:(id)sender {
    [self GetSetting];
}



- (void) AlertView:(NSString*)sTitle Msg:(NSString*)sMsg
{
    UIAlertController *myAlertController = [UIAlertController alertControllerWithTitle:sTitle
                                                                               message: sMsg
                                                                        preferredStyle:UIAlertControllerStyleAlert                   ];
    
    //Step 2: Create a UIAlertAction that can be added to the alert
    UIAlertAction* ok = [UIAlertAction
                         actionWithTitle:@"확인"
                         style:UIAlertActionStyleDefault
                         handler:^(UIAlertAction * action)
                         {
                             //Do some thing here, eg dismiss the alertwindow
                             [myAlertController dismissViewControllerAnimated:YES completion:nil];
                             
                         }];
    
    //Step 3: Add the UIAlertAction ok that we just created to our AlertController
    [myAlertController addAction: ok];
    
    //Step 4: Present the alert to the user
    [self presentViewController:myAlertController animated:YES completion:nil];
}

@end



